<?php
namespace PageIntro\Widgets;

use \Elementor\Controls_Manager as Controls_Manager;
use \Elementor\Frontend;
use \Elementor\Group_Control_Border as Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow as Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography as Group_Control_Typography;
use \Elementor\Utils as Utils;
use \Elementor\Widget_Base as Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Page Intro Header
 *
 * Elementor widget for Logo Showcase
 *
 * @since 1.0.0
 */
class Page_Intro_Header extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'page-intro-header';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Style + Header', 'elementor-page-intro' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-heading';
	}

	/**
	 * Retrieve the registered menu.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 */
	public function get_menu() {
		$menu_list = get_registered_nav_menus();
		
		$menu_list1 = array();
		foreach($menu_list as $location => $description) {
			$menu_list1[] = $description;
		}
	
		$menu_list2 = array();
		foreach($menu_list as $location => $description) {
			$menu_list2[] = $location;
		}	
	
		$menu_list_revenge = array_combine($menu_list2, $menu_list1);		
		
		return $menu_list_revenge;
	}



	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'page-intro' ];
	}


	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'widget_scripts' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {
		
		$this->start_controls_section(
			'section_header',
			[
				'label' => esc_html__( 'Header', 'elementor-page-intro' ), // Section display name
			]
		);		
		
		
		$this->add_control(
			'epi_header_position',
			[
				'label' => esc_html__( 'Header Position', 'elementor-page-intro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'epi-header-top',
				'options' => [
					'epi-header-top' 		=> esc_html__( 'Top', 'elementor-page-intro' ),
					'epi-header-bottom' 	=> esc_html__( 'Bottom', 'elementor-page-intro' )
				]
			]
		);		
		
		$this->add_control(
			'epi_header_type',
			[
				'label' => esc_html__( 'Header Type', 'elementor-page-intro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'vcmp-header-normal',
				'options' => [
					'vcmp-header-normal' 		=> esc_html__( 'Normal', 'elementor-page-intro' ),
					'vcmp-header-sticky' 		=> esc_html__( 'Sticky', 'elementor-page-intro' ),
					'vcmp-header-sticky-v2' 		=> esc_html__( 'Sticky (First Slide no header)', 'elementor-page-intro' )
				]
			]
		);			
		
		$this->add_control(
			'epi_header_background_color',
			[
				'label' => esc_html__( 'Background Color', 'elementor-page-intro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#FC615D'			
			]
		);		
		
		$this->add_control(
			'epi_header_padding',
			[
				'label' => esc_html__( 'Padding ie: 50px or 20px 10px 20px 10px', 'elementor-page-intro' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT
			]
		);		
		
		$this->add_control(
			'epi_header_margin',
			[
				'label' => esc_html__( 'Margin ie: 50px or 20px 10px 20px 10px', 'elementor-page-intro' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT
			]
		);			
				
		$this->end_controls_section();

  		$this->start_controls_section(
  			'section_logo',
  			[
  				'label' => esc_html__( 'Logo', 'elementor-page-intro' )
  			]
		);		


		$this->add_control(
			'epi_header_logo_active',
			[
				'label' => esc_html__( 'Show Logo', 'elementor-page-intro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'on',
				'options' => [
					'on' 		=> esc_html__( 'Show', 'elementor-page-intro' ),
					'off' 		=> esc_html__( 'Hidden', 'elementor-page-intro' )
				]
			]
		);	

		$this->add_control(
			'epi_header_logo',
			[
				'label' => esc_html__( 'Logo', 'elementor-page-intro' ),
				'type' => \Elementor\Controls_Manager::MEDIA
			]	
		);

		$this->add_control(
			'epi_header_logo_position',
			[
				'label' => esc_html__( 'Position', 'elementor-page-intro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'epi-logo-left',
				'options' => [
					'epi-logo-left' 		=> esc_html__( 'Left', 'elementor-page-intro' ),
					'epi-logo-right' 		=> esc_html__( 'Right', 'elementor-page-intro' ),
					'epi-logo-top' 		=> esc_html__( 'Top', 'elementor-page-intro' ),
					'epi-logo-bottom' 		=> esc_html__( 'Bottom', 'elementor-page-intro' )
				]
			]
		);			

		$this->add_control(
			'epi_header_logo_align',
			[
				'label' => esc_html__( 'Align', 'elementor-page-intro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'left',
				'options' => [
					'left' 		=> esc_html__( 'Left', 'elementor-page-intro' ),
					'right' 	=> esc_html__( 'Right', 'elementor-page-intro' ),
					'top' 		=> esc_html__( 'Center', 'elementor-page-intro' )
				]
			]
		);	

		$this->add_control(
			'epi_header_logo_link',
			[
				'label' => esc_html__( 'Link', 'elementor-page-intro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'home-page',
				'options' => [
					'home-page' 		=> esc_html__( 'Home Page', 'elementor-page-intro' ),
					'same-page' 		=> esc_html__( 'Same Page', 'elementor-page-intro' ),
					'custom-url' 		=> esc_html__( 'Custom Url', 'elementor-page-intro' )
				]
			]
		);

		$this->add_control(
			'epi_header_logo_custom_url',
			[
				'label' => esc_html__( 'Custom Url', 'elementor-page-intro' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'condition'	=> [
					'epi_header_logo_link'	=> 'custom-url'
				]
			]
		);

		$this->add_control(
			'epi_header_logo_target',
			[
				'label' => esc_html__( 'Target', 'elementor-page-intro' ),
				'type' => Controls_Manager::SELECT,
				'default' => '_self',
				'options' => [
					'_blank' 		=> esc_html__( 'Blank (New Window)', 'elementor-page-intro' ),
					'_self' 		=> esc_html__( 'Self (Same Window)', 'elementor-page-intro' )
				]
			]
		);

		$this->end_controls_section();

  		$this->start_controls_section(
  			'section_menu',
  			[
  				'label' => esc_html__( 'Menù', 'elementor-page-intro' )
  			]
		);		

		$this->add_control(
			'epi_header_menu_list',
			[
				'label' => esc_html__( 'Menu Position', 'elementor-page-intro' ),
				'type' => Controls_Manager::SELECT,
				'options' => $this->get_menu()
			]
		);

		$this->add_control(
			'epi_header_menu_text_align',
			[
				'label' => esc_html__( 'Text Align', 'elementor-page-intro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'left',
				'options' => [
					'left' 		=> esc_html__( 'Left', 'elementor-page-intro' ),
					'right' 		=> esc_html__( 'Right', 'elementor-page-intro' ),
					'center' 		=> esc_html__( 'Center', 'elementor-page-intro' )
				]
			]
		);

		$this->add_control(
			'epi_header_menu_font_weight',
			[
				'label' => esc_html__( 'Font Weight', 'elementor-page-intro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'normal',
				'options' => [
					'normal' 	=> esc_html__( 'Normal', 'elementor-page-intro' ),
					'bold' 		=> esc_html__( 'Bold', 'elementor-page-intro' )
				]
			]
		);

		$this->add_control(
			'epi_header_menu_text_transform',
			[
				'label' => esc_html__( 'Text Trasform', 'elementor-page-intro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none' 				=> esc_html__( 'Normal', 'elementor-page-intro' ),
					'uppercase' 		=> esc_html__( 'Uppercase', 'elementor-page-intro' ),
					'lowercase' 		=> esc_html__( 'Lowercase', 'elementor-page-intro' ),
					'capitalize' 		=> esc_html__( 'Capitalize', 'elementor-page-intro' )
				]
			]
		);

		$this->add_control(
			'epi_header_menu_text_decoration',
			[
				'label' => esc_html__( 'Text Decoration', 'elementor-page-intro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none' 				=> esc_html__( 'None', 'elementor-page-intro' ),
					'underline' 		=> esc_html__( 'Underline', 'elementor-page-intro' ),
					'overline' 			=> esc_html__( 'Overline', 'elementor-page-intro' )
				]
			]
		);

		$this->add_control(
			'epi_header_menu_font_size',
			[
				'label' => esc_html__( 'Font Size (ie: 20px)', 'elementor-page-intro' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'epi_header_menu_font_color',
			[
				'label' => esc_html__( 'Menu Font Color', 'elementor-page-intro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#FC615D'			
			]
		);	

		$this->add_control(
			'epi_header_menu_font_color_link',
			[
				'label' => esc_html__( 'Menu Link Color', 'elementor-page-intro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#FC615D'			
			]
		);

		$this->add_control(
			'epi_header_menu_font_color_over_link',
			[
				'label' => esc_html__( 'Menu Over Color', 'elementor-page-intro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#FC615D'			
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'elementor-page-intro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'epi_page_font_color',
			[
				'label' => esc_html__( 'Page Font Color', 'elementor-page-intro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#FC615D'			
			]
		);

		$this->add_control(
			'epi_page_font_color_link',
			[
				'label' => esc_html__( 'Page Link Color', 'elementor-page-intro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#FC615D'				
			]
		);
		
		$this->add_control(
			'epi_page_font_color_over_link',
			[
				'label' => esc_html__( 'Page Over Color', 'elementor-page-intro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#FC615D'			
			]
		);

		$this->end_controls_section();
	}

	 
	 /**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		static $instance = 0;
		$instance++;		
		$settings = $this->get_settings_for_display();

		wp_enqueue_style( 'epi-header' );
		wp_enqueue_style( 'epi-main' );
		wp_enqueue_style( 'epi-menu' );
		wp_enqueue_script( 'epi-menu-js' );
		wp_enqueue_script( 'epi-mobile-menu-js' );
		wp_enqueue_script( 'modernizr' );
		wp_enqueue_script( 'epi-header-js' );

		echo '<style type="text/css">';	
		
		echo 'body {
						color:'.esc_html($settings['epi_page_font_color']).';
					}
					a {
						color:'.esc_html($settings['epi_page_font_color_link']).';
					}
					a:hover {
						color:'.esc_html($settings['epi_page_font_color_over_link']).';
					}';
		
		echo '.epi-header { 
				background:'.esc_html($settings['epi_header_background_color']).'; 
				padding:'.esc_html($settings['epi_header_padding']).';
				margin:'.esc_html($settings['epi_header_margin']).';		
		}
		.epi-logo {
				text-align:'.esc_html($settings['epi_header_logo_align']).';
		}			
		.epi-menu {
				color:'.esc_html($settings['epi_header_menu_font_color']).';
				text-align:'.esc_html($settings['epi_header_menu_text_align']).';
		}
		.epi-menu .cbp-tm-menu > li > a {
				font-weight:'.esc_html($settings['epi_header_menu_font_weight']).';
				font-size:'.esc_html($settings['epi_header_menu_font_size']).';
				text-transform:'.esc_html($settings['epi_header_menu_text_transform']).';
				text-decoration:'.esc_html($settings['epi_header_menu_text_decoration']).'!important;
				color:'.esc_html($settings['epi_header_menu_font_color_link']).';
		}
		.epi-menu a:hover {
				color:'.esc_html($settings['epi_header_menu_font_color_over_link']).'!important;
		}	
		</style>';
		
		echo "<script type=\"text/javascript\">
				jQuery(function($){
					$(document).ready(function(){
						$('#cbp-tm-menu').mobileMenu({topOptionText: '".__('Select Page','vcpageintro')."', groupPageText: '".__('Main','vcpageintro')."',switchWidth: 1023});
					});
				});
		</script>";
		
		$logo_image_url = wp_get_attachment_image_src( $settings['epi_header_logo']['id'] );	
		
		if(esc_html($settings['epi_header_logo_link']) == 'home-page') {
			$logo_url = get_home_url();
		} elseif (esc_html($settings['epi_header_logo_link']) == 'same-page') {
			$logo_url = '';
		} elseif (esc_html($settings['epi_header_logo_link']) == 'custom-url') {
			$logo_url = esc_html($settings['epi_header_logo_custom_url']);
		}
		
		$epi_header_type_value = esc_html($settings['epi_header_type']);
		
		if(esc_html($settings['epi_header_type']) == 'vcmp-header-sticky' || esc_html($settings['epi_header_type']) == 'vcmp-header-sticky-v2') {
			$epi_header_sticky_active = 'vcmp-header-sticky-container';
		} else {
			$epi_header_sticky_active = '';
		}
		
		echo '<header class="epi-header '.esc_html($settings['epi_header_position']).' '.esc_html($settings['epi_header_logo_position']).' '.$epi_header_sticky_active.' '.esc_html($settings['epi_header_type']).'">';
		
		if(esc_html($settings['epi_header_position']) == 'epi-header-top' || esc_html($settings['epi_header_position']) == 'epi-header-bottom') {
			if((esc_html($settings['epi_header_logo_position']) == 'epi-logo-left' || esc_html($settings['epi_header_logo_position']) == 'epi-logo-top') && esc_html($settings['epi_header_logo_active']) == 'on') {
				echo '<div class="epi-logo"><a href="'.$logo_url.'" target="'.esc_html($settings['epi_header_logo_target']).'"><img src="'.$logo_image_url[0].'"></a></div>';
			}
			echo '<div class="epi-menu">';
			if(esc_html($settings['epi_header_menu_list'])) {
				if ( function_exists( 'wp_nav_menu' ) && has_nav_menu(esc_html($settings['epi_header_menu_list'])) )  {
							echo wp_nav_menu(array(
									'container'       => 'ul', 
									'theme_location'  => esc_html($settings['epi_header_menu_list']),
									'container_class' => false, 
									'container_id'    => false,
									'menu_class'      => 'cbp-tm-menu', 
									'fallback_cb'	  => 'nav_fallback',
									'menu_id'         => 'cbp-tm-menu',
									'echo'			  => false, 
								)
								);
							}
			}				
			echo '</div>';
			echo '<div id="epi-menu-responsive"></div>';		
			if((esc_html($settings['epi_header_logo_position']) == 'epi-logo-right' || esc_html($settings['epi_header_logo_position']) == 'epi-logo-bottom') && esc_html($settings['epi_header_logo_active']) == 'on') {
				echo '<div class="epi-logo"><a href="'.$logo_url.'" target="'.esc_html($settings['epi_header_logo_target']).'"><img src="'.$logo_image_url[0].'"></a></div>';
			}					 
		}
		
		echo '<div class="epi-clear"></div></header>';
		
		
		/* HEADER BOTTOM */
		
		if(esc_html($settings['epi_header_position']) == 'epi-header-bottom' && esc_html($settings['epi_header_type']) == 'vcmp-header-sticky') {
			
		echo '<header class="epi-header epi-header-sticky '.esc_html($settings['epi_header_position']).' '.esc_html($settings['epi_header_logo_position']).' '.esc_html($settings['epi_header_type']).'">';
		
		if(esc_html($settings['epi_header_position']) == 'epi-header-top' || esc_html($settings['epi_header_position']) == 'epi-header-bottom') {
			if((esc_html($settings['epi_header_logo_position']) == 'epi-logo-left' || esc_html($settings['epi_header_logo_position']) == 'epi-logo-top') && esc_html($settings['epi_header_logo_active']) == 'on') {
				echo '<div class="epi-logo"><a href="'.$logo_url.'" target="'.esc_html($settings['epi_header_logo_target']).'"><img src="'.$logo_image_url[0].'"></a></div>';
			}
			echo '<div class="epi-menu">';
			if(esc_html($settings['epi_header_menu_list'])) {
				if ( function_exists( 'wp_nav_menu' ) && has_nav_menu(esc_html($settings['epi_header_menu_list'])) )  {
							echo wp_nav_menu(array(
									'container'       => 'ul', 
									'theme_location'  => esc_html($settings['epi_header_menu_list']),
									'container_class' => false, 
									'container_id'    => false,
									'menu_class'      => 'cbp-tm-menu', 
									'fallback_cb'	  => 'nav_fallback',
									'menu_id'         => 'cbp-tm-menu',
									'echo'			  => false, 
								)
								);
							}
			}
			echo '</div>';
			echo '<div id="epi-menu-responsive"></div>';
			if((esc_html($settings['epi_header_logo_position']) == 'epi-logo-right' || esc_html($settings['epi_header_logo_position']) == 'epi-logo-bottom') && esc_html($settings['epi_header_logo_active']) == 'on') {
				echo '<div class="epi-logo"><a href="'.$logo_url.'" target="'.esc_html($settings['epi_header_logo_target']).'"><img src="'.$logo_image_url[0].'"></a></div>';
			}					 
		}
		
		echo '<div class="epi-clear"></div></header>';		
			
			
		}
		
		/* #HEADER BOTTOM */
		
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _content_template() {}
}
